<?php $__env->startSection('content'); ?>
    <?php
        $plans = App\Models\Plan::with('timeSetting')
            ->whereHas('timeSetting', function ($time) {
                $time->where('status', 1);
            })
            ->where('status', 1)
            ->where('featured', 1)
            ->get();
        $gatewayCurrency = null;
        if (auth()->check()) {
            $gatewayCurrency = App\Models\GatewayCurrency::whereHas('method', function ($gate) {
                $gate->where('status', 1);
            })
                ->with('method')
                ->orderby('method_code')
                ->get();
        }
    ?>

    <section class="plan-section pt-120 pb-120 bg--light">
        <div class="container">
            <div class="row gy-4 justify-content-center">
                <?php echo $__env->make($activeTemplate . 'partials.plan', ['plans' => $plans], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <?php
                $workProcess = getContent('how_it_work.content', true);
                $workProcessElements = getContent('how_it_work.element', null, false, true);
            ?>

            <div class="how-it-work pt-5">
                <div class="mb-3">
                    <h4><?php echo e(__(@$workProcess->data_values->title)); ?></h4>
                    <p><?php echo __(@$workProcess->data_values->subtitle) ?></p>
                </div>
                <div class="row gy-4">
                    <?php $__currentLoopData = $workProcessElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $process): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-3 col-sm-6">
                            <div class="work-process-card">
                                <div class="icon-area">
                                    <img src="<?php echo e(frontendImage('how_it_work', $process->data_values->image, '50x50')); ?>" alt="">
                                </div>
                                <h5 class="my-1"><?php echo e(__($process->data_values->title)); ?></h5>
                                <p><?php echo e(__($process->data_values->content)); ?></p>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>

    <?php if(gs('user_ranking')): ?>
        <?php
            $userRanking = getContent('ranking.content', true);
            $userRankings = App\Models\UserRanking::active()->get();
        ?>

        <?php if($userRankings->count()): ?>
            <section class="referral-level-section border-top-1 pt-120 pb-120">
                <div class="container">
                    <div class="mb-3">
                        <h4><?php echo e(__(@$userRanking->data_values->heading)); ?></h4>
                        <p><?php echo e(__(@$userRanking->data_values->sub_heading)); ?></p>
                    </div>
                    <div class="referral__level__area">
                        <?php
                            $firstPercent = 20;
                            $lastPercent = 100;
                            $perItem = ($lastPercent - $firstPercent) / ($userRankings->count() > 1 ? $userRankings->count() - 1 : $userRankings->count());
                        ?>
                        <?php $__currentLoopData = $userRankings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="referral__level__item">
                                <div class="referral__level__item__inner">
                                    <div class="referral__left">
                                        <div class="referral__level__thumb">
                                            <img src="<?php echo e(getImage(getFilePath('userRanking') . '/' . $rank->icon, getFileSize('userRanking'))); ?>" alt="referral">
                                        </div>
                                        <div class="referral__level__name">
                                            <?php echo e(__($rank->name)); ?>

                                        </div>
                                    </div>
                                    <div class="referral__right">
                                        <div class="referral__level__content custom-width" data-custom_width="<?php echo e($perItem * $loop->index + $firstPercent); ?>">
                                            <div class="referral__level__content__content">
                                                <span><i class="las la-coins"></i> <?php echo app('translator')->get('Bonus'); ?>: <?php echo e(showAmount($rank->bonus)); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="referral__tooltip">
                                    <ul>
                                        <li class="d-flex justify-content-between">
                                            <?php echo app('translator')->get('Level'); ?>
                                            <span><?php echo e(__($rank->level)); ?></span>
                                        </li>
                                        <li class="d-flex justify-content-between">
                                            <?php echo app('translator')->get('Minimum Invest'); ?>
                                            <span><?php echo e(showAmount($rank->minimum_invest)); ?></span>
                                        </li>
                                        <li class="d-flex justify-content-between">
                                            <?php echo app('translator')->get('Team Invest'); ?>
                                            <span><?php echo e(showAmount($rank->min_referral_invest)); ?></span>
                                        </li>
                                        <li class="d-flex justify-content-between">
                                            <?php echo app('translator')->get('No. of Direct Referral'); ?>
                                            <span><?php echo e($rank->min_referral); ?></span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </section>
        <?php endif; ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php if(gs('user_ranking')): ?>
    <?php $__env->startPush('script'); ?>
        <script>
            (function($) {
                "use strict";
                $('.custom-width').each(function(index, value) {
                    $(value).css("max-width", `${$(value).data('custom_width')}%`);
                });
            })(jQuery);
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u757032006/domains/metalfusion.pro/public_html/core/resources/views/templates/invester/home.blade.php ENDPATH**/ ?>